/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen;

import com.google.common.collect.Maps;
import doggytalents.client.screen.ScreenUtil;
import doggytalents.client.screen.StringEntrySelectScreen;
import doggytalents.client.screen.framework.widget.FlatButton;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.CanineTrackerData;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.PacketDistributor;
import org.apache.commons.lang3.tuple.Triple;

public class CanineTrackerScreen
extends StringEntrySelectScreen {
    private Player player;
    private final ArrayList<String> dogNameList = new ArrayList();
    private final ArrayList<UUID> dogIdList = new ArrayList();
    private final Map<UUID, Integer> dogDistanceMap = Maps.newHashMap();
    private final Map<UUID, BlockPos> dogPosMap = Maps.newHashMap();
    private boolean showUuid = false;

    public CanineTrackerScreen(Player player) {
        super((Component)Component.m_237115_((String)"doggytalents.screen.conducting_bone"));
        this.player = player;
    }

    public static void open() {
        Minecraft mc = Minecraft.m_91087_();
        CanineTrackerScreen screen = new CanineTrackerScreen((Player)mc.f_91074_);
        mc.m_91152_((Screen)screen);
        screen.requestDogs();
    }

    @Override
    protected void addUtilitiesButton() {
        int mX = this.f_96543_ / 2;
        int mY = this.f_96544_ / 2;
        int pY = mY - 100;
        FlatButton showUuid = new FlatButton(mX - 100 - 60 - 2, pY, 60, 20, (Component)Component.m_237115_((String)"doggytalents.screen.whistler.heel_by_name.show_uuid"), btn -> {
            btn.m_93666_((Component)Component.m_237115_((String)("doggytalents.screen.whistler.heel_by_name." + (this.showUuid ? "show" : "hide") + "_uuid")));
            this.showUuid = !this.showUuid;
        });
        FlatButton help = new FlatButton(mX - 100 - 20 - 2, pY += showUuid.m_93694_() + 2, 20, 20, (Component)Component.m_237113_((String)"?"), b -> {}){

            public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float pTicks) {
                super.m_88315_(graphics, mouseX, mouseY, pTicks);
                if (!this.f_93622_) {
                    return;
                }
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(Component.m_237115_((String)"doggytalents.screen.radar.help_title").m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true))));
                String str = I18n.m_118938_((String)"doggytalents.screen.radar.help", (Object[])new Object[0]);
                list.addAll(ScreenUtil.splitInto(str, 150, CanineTrackerScreen.this.f_96547_));
                graphics.m_280666_(CanineTrackerScreen.this.f_96547_, list, mouseX, mouseY);
            }
        };
        this.m_142416_((GuiEventListener)showUuid);
        this.m_142416_((GuiEventListener)help);
    }

    @Override
    protected void drawEntry(GuiGraphics graphics, int entry_x, int entry_y, int entry_id, boolean is_selected) {
        super.drawEntry(graphics, entry_x, entry_y, entry_id, is_selected);
        int textx1 = this.f_96543_ / 2 + 100 - 35;
        UUID dogId = this.dogIdList.get(entry_id);
        int dist = this.dogDistanceMap.get(dogId);
        Object text1 = dist > 99999 ? "far" : "" + dist;
        int color = -1;
        if (is_selected) {
            color = this.getHightlightSelectedColor();
        }
        graphics.m_280488_(this.f_96547_, (String)text1, textx1, entry_y, color);
    }

    @Override
    protected void drawNoEntryMsg(GuiGraphics graphics, int x, int y) {
        graphics.m_280488_(this.f_96547_, I18n.m_118938_((String)"doggytalents.screen.conducting_bone.no_dog_found", (Object[])new Object[0]), x, y, 16058890);
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.mayRenderShowUUID(graphics, mouseX, mouseY, partialTicks);
    }

    private void mayRenderShowUUID(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (!this.showUuid) {
            return;
        }
        Optional<Integer> hover_entry_optional = this.getHoveredEntry(mouseX, mouseY);
        if (!hover_entry_optional.isPresent()) {
            return;
        }
        int entry_id = hover_entry_optional.get();
        UUID uuid = this.dogIdList.get(entry_id);
        MutableComponent uuid_c1 = Component.m_237113_((String)uuid.toString()).m_130940_(ChatFormatting.GRAY);
        if (this.f_96544_ >= 273) {
            int mX = this.f_96543_ / 2;
            int mY = this.f_96544_ / 2;
            int uuid_width = this.f_96547_.m_92852_((FormattedText)uuid_c1);
            int tX = mX - uuid_width / 2;
            int tY = mY + this.getSelectAreaSize() / 2 + 23;
            graphics.m_280430_(this.f_96547_, (Component)uuid_c1, tX, tY, -1);
        } else {
            graphics.m_280666_(this.f_96547_, List.of(uuid_c1), mouseX, mouseY);
        }
    }

    @Override
    protected void onEntrySelected(int id) {
        UUID uuid = this.dogIdList.get(id);
        this.startLocateDog(uuid);
        Minecraft.m_91087_().m_91152_(null);
    }

    private void requestDogs() {
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new CanineTrackerData.RequestDogsData());
    }

    public void assignResponse(List<Triple<UUID, String, BlockPos>> dogLs) {
        this.dogNameList.clear();
        this.dogIdList.clear();
        this.dogDistanceMap.clear();
        this.dogPosMap.clear();
        for (Triple<UUID, String, BlockPos> entry : dogLs) {
            this.dogNameList.add((String)entry.getMiddle());
            this.dogIdList.add((UUID)entry.getLeft());
            BlockPos pos = (BlockPos)entry.getRight();
            int distance = Mth.m_14167_((float)Mth.m_14116_((float)((float)this.player.m_20183_().m_123331_((Vec3i)pos))));
            this.dogDistanceMap.put((UUID)entry.getLeft(), distance);
            this.dogPosMap.put((UUID)entry.getLeft(), pos);
        }
        this.updateEntries(this.dogNameList);
    }

    private void startLocateDog(UUID uuid) {
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new CanineTrackerData.StartLocatingData(uuid));
    }

    public boolean m_7043_() {
        return false;
    }
}

